
// Adafruit Motor shield library
// copyright Adafruit Industries LLC, 2009
// this code is public domain, enjoy!
// Съемка сферической панорамы камерой NEX-5 с управлением по BT от Android
// www.rwpbb.ru, 2011 
#include <AFMotor.h>
#include <MeetAndroid.h>
// declare MeetAndroid so that you can call functions with it
MeetAndroid meetAndroid;
int pulscount=1;  // Счетчик числа импульсов в пакете ИК
int puls = 4;    // Число пакетов ИК

AF_Stepper motor1(48, 1); // Число шагов на один оборот мотора для 1 двигателя
AF_Stepper motor2(200, 2);

int buttonPin = 9;       // Ножка перемычки. Если 5В, то съемка с насадкой в два ряда 
int buttonState = 0;     // Состояние перемычки
int wzat = 3000;         // Время нажатия кнопки затвора - 3 с
int wp = 4000;           // Пауза перед спуском затвора - 4 с
int mstepx = 280;        // Число шагов двигателя при повороте на единичный угол по горизонтали (360 - 1400)
int mstepxd = 280;       // Число шагов двигателя
int naprx = 1;           // Направление вращения. Вперед 1, Назад -1 
int nmstepx = 4;         // 5 снимков в ряду по горизонтали для съемки с насадкой
int mstepy = 1672;       // Число шагов двигателя при повороте на единичный угол по вертикали   (180 - 5000)
int mstepyd = 1672;
int napry = 1;           // Направление вращения. Вперед 1, Назад -1 
int nmstepy = 1;
int flagO = 1;            //Флаг наличия насадки 1, без 0
int ugolV = 90;
int ugolG = 0;
void setup() 
{ 
  Serial.begin(57600); 
  
  // register callback functions, which will be called when an associated event occurs.
  meetAndroid.registerFunction(fo, 'o');//Затвор
  meetAndroid.registerFunction(fp, 'p');//Низ  
  meetAndroid.registerFunction(fq, 'q');//Право 
  meetAndroid.registerFunction(fr, 'r');//Лево
  meetAndroid.registerFunction(fs, 's');//Верх  
  meetAndroid.registerFunction(ft, 't');//Пуск
  meetAndroid.registerFunction(fk, 'k');//Передача параметра - Задержка
  meetAndroid.registerFunction(fl, 'l');//Передача параметра - Объектив
  meetAndroid.registerFunction(fm, 'm');//Передача параметра
  meetAndroid.registerFunction(fn, 'n');//Передача параметра
  meetAndroid.registerFunction(fe, 'e');//Передача параметра
  meetAndroid.registerFunction(ff, 'f');//Передача параметра
  meetAndroid.registerFunction(fg, 'g');//Передача параметра
  
 TCCR1A = _BV(COM1A1) | _BV(COM1B1) ; // phase and frequency correct mode. NON-inverted mode
 TCCR1B = _BV(WGM13) | _BV(CS10);     // Делитель N = 1 - (_BV(CS10)); 8 - (_BV(CS11))
 OCR1B = 0;              // Скважность 102 - рабочий сигнал, 0 - сигнал отсутствует
 ICR1 = 210;             // Частота 16мГц/2*N*ICR1 = 16000кГц/(2*1*210)=38095Гц
 pinMode(10, OUTPUT);    // К 10 ножке подключен ИК светодиод АЛ107 через сопротивление 1 кОм
  
 pinMode(buttonPin, INPUT); // Включаем ножку на прием сигналов
 digitalWrite(buttonPin, LOW); //включаем подтягивающие резисторы на землю
 buttonState = digitalRead(buttonPin); // Чтение состояния перемычки
 if (buttonState == LOW){flagO = 0;}
 motor1.setSpeed(80);         // Скорость вращения  80 оборотов в минуту 
 motor1.release();            // Отключаем питание двигателя
 motor2.setSpeed(40);  
 motor2.release();
                         
        
}
void loop()  {
   meetAndroid.receive(); // you need to keep this in your loop() to receive events

    }

void IR_Sony()  { //Подпрограмма подачи ИК сигналя для спуска зотвора камеры NEX5
  digitalWrite(13, HIGH);//Индикация паузы светодиодом на плате
  delay(wp);// Пауза перед спуском затвора 
  digitalWrite(13, LOW);
  pulscount=1;  
   while (pulscount<puls)          // цикл пакета импульсов  
    
    {OCR1B = 102;   // включаем светодиод
    delayMicroseconds(2432);       // светодиод горит микросекунд
    OCR1B = 0;     // выключаем светодиод
    delayMicroseconds(576);       // светодиод выключен  микросекунд
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(1216);       
    OCR1B = 0;     
    delayMicroseconds(576); 
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(640);       
    OCR1B = 0;     
    delayMicroseconds(576);
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(1216);       
    OCR1B = 0;     
    delayMicroseconds(576);
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(1216);       
    OCR1B = 0;     
    delayMicroseconds(576);
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(640);       
    OCR1B = 0;     
    delayMicroseconds(576);
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(1216);       
    OCR1B = 0;     
    delayMicroseconds(576);
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(640);       
    OCR1B = 0;     
    delayMicroseconds(576);
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(640);       
    OCR1B = 0;     
    delayMicroseconds(576);
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(1216);       
    OCR1B = 0;     
    delayMicroseconds(576);
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(640);       
    OCR1B = 0;     
    delayMicroseconds(576);
     OCR1B = 102;   // включаем светодиод
    delayMicroseconds(1216);       
    OCR1B = 0;     
    delayMicroseconds(576);
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(1216);       
    OCR1B = 0;     
    delayMicroseconds(576);
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(1216);       
    OCR1B = 0;     
    delayMicroseconds(576);
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(640);       
    OCR1B = 0;     
    delayMicroseconds(576);
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(640);       
    OCR1B = 0;     
    delayMicroseconds(576);
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(640);       
    OCR1B = 0;     
    delayMicroseconds(576);
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(1216);       
    OCR1B = 0;     
    delayMicroseconds(576);
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(1216);       
    OCR1B = 0;     
    delayMicroseconds(576);
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(1216);       
    OCR1B = 0;     
    delayMicroseconds(576);
    OCR1B = 102;   // включаем светодиод
    delayMicroseconds(1216);       
    OCR1B = 0;     
    delayMicroseconds(11136);
    pulscount++;
    }
    digitalWrite(13, HIGH);
    delay(wzat); // Время нажатия кнопки затвора
    digitalWrite(13, LOW);    
}

void Pano_Motor()  {
  if (flagO == 0) 
      {
        mstepx = 140;
        nmstepx = 9;
        mstepy = 1500;
        nmstepy = 2;
      }
      else
      {
        mstepx = 280;
        nmstepx = 4;
        mstepy = 1672;
        nmstepy = 1;
      }
     // Поворачиваем вниз      
     mstepyd =  mstepy*nmstepy/2;
     napry = -1;
     motor2.step(mstepyd,  FORWARD, DOUBLE);   
     motor2.release();
     SendUgolV();//Передаем данные об  угле телефону     

  for (int i=0; i <= nmstepx; i++)
      {
      
       IR_Sony();   // Нажимаем спусковую кнопку
       mstepxd = mstepx;
       naprx = 1;
       motor1.step(mstepxd, FORWARD, DOUBLE); 
       motor1.release();
       SendUgolG();//Передаем данные об горизонтальном угле телефону
      } 
 
     // Поворачиваем на пол угла по горизонтали
     mstepxd = mstepx/2;
     naprx = 1;
     motor1.step(mstepxd, FORWARD, DOUBLE); 
     motor1.release();
     SendUgolG();//Передаем данные об горизонтальном угле телефону
     
     // Поворачиваем камеру вверх
     mstepyd =  mstepy;
     napry = 1;
     motor2.step(mstepyd,  BACKWARD, DOUBLE);   
     motor2.release();
     SendUgolV();//Передаем данные об  угле телефону
     
  for (int i=0; i <= (nmstepx-1); i++)
            {     
       IR_Sony();   // Нажимаем спусковую кнопку
                
       mstepxd = mstepx;
       naprx = 1;
       motor1.step(mstepxd, FORWARD, DOUBLE); 
       motor1.release();
       SendUgolG();//Передаем данные об горизонтальном угле телефону
            }
     
     IR_Sony();   // Нажимаем спусковую кнопку
      // Поворачиваем на пол угла по горизонтали
     mstepxd = mstepx/2;
     naprx = 1;
     motor1.step(mstepxd, FORWARD, DOUBLE); 
     motor1.release();
     SendUgolG();//Передаем данные об горизонтальном угле телефону
 
  if (flagO == 0) 
      {
       // Поворачиваем камеру вверх
     mstepyd =  mstepy;
     napry = 1;
     motor2.step(mstepyd,  BACKWARD, DOUBLE);   
     motor2.release();
     SendUgolV();//Передаем данные об  угле телефону
       
    for (int i=0; i <= (nmstepx); i++)
              {     
         IR_Sony();   // Нажимаем спусковую кнопку
                  
         mstepxd = mstepx;
         naprx = 1;
         motor1.step(mstepxd, FORWARD, DOUBLE); 
         motor1.release();
         SendUgolG();//Передаем данные об горизонтальном угле телефону
              }   
      
      }

     // Поворачиваем вниз в исходное состояние    
     mstepyd =  mstepy*nmstepy/2;
     napry = -1;
     motor2.step(mstepyd,  FORWARD, DOUBLE);   
     motor2.release();
     SendUgolV();//Передаем данные об  угле телефону
     
}

void fk(byte flag, byte numOfValues)
{

     wp = 1000*meetAndroid.getInt();
  
}

void fl(byte flag, byte numOfValues)
{

     flagO = meetAndroid.getInt();
  if(flagO == 0){
  digitalWrite(13, HIGH);//Индикация светодиодом на плате
  delay(1000); 
  digitalWrite(13, LOW);
  delay(1000);
  digitalWrite(13, HIGH);//Индикация светодиодом на плате
  delay(1000); 
  digitalWrite(13, LOW);}
  if(flagO == 1){
  digitalWrite(13, HIGH);//Индикация светодиодом на плате
  delay(300); 
  digitalWrite(13, LOW);
  delay(300);
  digitalWrite(13, HIGH);//Индикация светодиодом на плате
  delay(300); 
  digitalWrite(13, LOW);
  delay(300);
  digitalWrite(13, HIGH);//Индикация светодиодом на плате
  delay(300); 
  digitalWrite(13, LOW);
  delay(300);
  digitalWrite(13, HIGH);//Индикация светодиодом на плате
  delay(300); 
  digitalWrite(13, LOW);
  delay(300);
  digitalWrite(13, HIGH);//Индикация светодиодом на плате
  delay(300); 
  digitalWrite(13, LOW);
}
}

void fm(byte flag, byte numOfValues)
{

    int flagM = meetAndroid.getInt();
  
}

void fn(byte flag, byte numOfValues)
{

    int flagN = meetAndroid.getInt();
  
}

void fe(byte flag, byte numOfValues)
{

    int flagE = meetAndroid.getInt();
  
}

void ff(byte flag, byte numOfValues)
{

    int flagF = meetAndroid.getInt();
  
}

void fg(byte flag, byte numOfValues)
{

    int flagG = meetAndroid.getInt();
  
}

void fo(byte flag, byte numOfValues)
{

     wzat = 1000*meetAndroid.getInt();
       IR_Sony();
}


void fp(byte flag, byte numOfValues)
{
 int fp = meetAndroid.getInt();
     mstepyd =  250*fp/9+1;
     napry = -1;
     motor2.step(mstepyd,  FORWARD, DOUBLE);   
     motor2.release();
     SendUgolV();//Передаем данные об  угле телефону
}

void fq(byte flag, byte numOfValues)//Поворот по часовой стрелке в 
{
  int fq = meetAndroid.getInt();
     mstepxd =  35*fq/9+1;
     naprx = 1;
     motor1.step(mstepxd, FORWARD, DOUBLE); 
     motor1.release();
     SendUgolG();//Передаем данные об горизонтальном угле телефону
}
void fr(byte flag, byte numOfValues)
{
  int fr = meetAndroid.getInt();
     mstepxd =  35*fr/9+1;
     naprx = -1;
     motor1.step(mstepxd,  BACKWARD, DOUBLE);  
     motor1.release();
     SendUgolG();//Передаем данные об горизонтальном угле телефону
}

void fs(byte flag, byte numOfValues)
{
  int fs = meetAndroid.getInt();
     mstepyd =  250*fs/9+1;
     napry = 1;
     motor2.step(mstepyd,  BACKWARD, DOUBLE);  
     motor2.release();
     SendUgolV();//Передаем данные об  угле телефону
}

void ft(byte flag, byte numOfValues)
{
      wzat = 1000*meetAndroid.getInt();
      Pano_Motor();
}

void SendUgolG()//Передаем данные об горизонтальном угле телефону
{
     ugolG = ugolG+naprx*9*mstepxd/35;
     if (ugolG > 360){
       ugolG = ugolG - 360;}
     if (ugolG < 0){
       ugolG = 360 + ugolG;}  
     meetAndroid.send("A");
     delay(200);
     meetAndroid.send(ugolG);
}

void SendUgolV()//Передаем данные об вертикальном угле телефону
{
     ugolV = ugolV+napry*9*mstepyd/250;
     meetAndroid.send("B");
     delay(200);
     meetAndroid.send(ugolV);
}
